<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once 'db.php'; // Include database connection

$response = array();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate required fields
    if (empty($_POST['redirectlink']) || empty($_POST['seotitle']) || empty($_FILES['image']['name']) || empty($_FILES['tabimage']['name']) || empty($_FILES['webimage']['name'])) {
        $response['status'] = 'error';
        $response['message'] = 'All fields are required';
        echo json_encode($response);
        exit;
    }

    // Get form data with sanitization
    $redirectlink = $conn->real_escape_string($_POST['redirectlink']);
    $seotitle = $conn->real_escape_string($_POST['seotitle']);
    $seodescription = $conn->real_escape_string($_POST['seodescription'] ?? '');

    // File upload handling
    $uploadDir = "../images/slider/";
    
    // Create directory if it doesn't exist
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // Function to handle file uploads
    function uploadFile($file, $uploadDir) {
        $filename = uniqid() . '_' . basename($file['name']);
        $targetPath = $uploadDir . $filename;
        
        // Check if file is an actual image
        $check = getimagesize($file['tmp_name']);
        if ($check === false) {
            return ['success' => false, 'message' => 'File is not an image'];
        }
        
        // Check file size (e.g., 5MB max)
        if ($file['size'] > 5000000) {
            return ['success' => false, 'message' => 'File is too large'];
        }
        
        // Allow certain file formats
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        if (!in_array($ext, $allowed)) {
            return ['success' => false, 'message' => 'Invalid file format'];
        }
        
        if (move_uploaded_file($file['tmp_name'], $targetPath)) {
            return ['success' => true, 'path' => $targetPath];
        } else {
            return ['success' => false, 'message' => 'Error uploading file'];
        }
    }

    // Process mobile image
    $mobileUpload = uploadFile($_FILES['image'], $uploadDir);
    if (!$mobileUpload['success']) {
        $response['status'] = 'error';
        $response['message'] = 'Mobile image: ' . $mobileUpload['message'];
        echo json_encode($response);
        exit;
    }
    $locationMobile = $mobileUpload['path'];

    // Process tab image
    $tabUpload = uploadFile($_FILES['tabimage'], $uploadDir);
    if (!$tabUpload['success']) {
        // Clean up already uploaded mobile image
        unlink($locationMobile);
        
        $response['status'] = 'error';
        $response['message'] = 'Tab image: ' . $tabUpload['message'];
        echo json_encode($response);
        exit;
    }
    $locationtab = $tabUpload['path'];

    // Process web image
    $webUpload = uploadFile($_FILES['webimage'], $uploadDir);
    if (!$webUpload['success']) {
        // Clean up already uploaded images
        unlink($locationMobile);
        unlink($locationtab);
        
        $response['status'] = 'error';
        $response['message'] = 'Web image: ' . $webUpload['message'];
        echo json_encode($response);
        exit;
    }
    $locationweb = $webUpload['path'];

    // Insert into database without prepared statements
    $sql = "INSERT INTO banner SET 
            mobilebanner = '$locationMobile',
            tabbanner = '$locationtab', 
            bannerimage = '$locationweb',
            redirectlink = '$redirectlink', 
            seotitle = '$seotitle', 
            seodescription = '$seodescription'";
    
    if ($conn->query($sql)) {
        $lastInsertID = $conn->insert_id;
        
        // Get max position and update
        $result = $conn->query("SELECT MAX(position) AS max_position FROM banner");
        $row = $result->fetch_assoc();
        $maxPosition = $row['max_position'] + 1;
        
        $updateSql = "UPDATE banner SET position = '$maxPosition' WHERE id = '$lastInsertID'";
        $conn->query($updateSql);
        
        $response['status'] = 'success';
        $response['message'] = 'Banner added successfully';
        $response['banner_id'] = $lastInsertID;
    } else {
        // Clean up uploaded files if database insert failed
        unlink($locationMobile);
        unlink($locationtab);
        unlink($locationweb);
        
        $response['status'] = 'error';
        $response['message'] = 'Database error: ' . $conn->error;
    }
} else {
    $response['status'] = 'error';
    $response['message'] = 'Invalid request method';
}

$conn->close();
echo json_encode($response);
?>